# WHMCS Clone - Hosting Management & Billing Platform

A comprehensive hosting management and billing platform built with Laravel 11, inspired by WHMCS.

## Features

### ✅ Phase 1 - Foundation (Complete)
- **Authentication System** - Login, Register, Password Reset, 2FA ready
- **Admin Panel** - Full dashboard with revenue stats, charts, recent activity
- **Client Portal** - Dashboard with services, invoices, tickets, domains overview
- **Role-based Access** - Admin, Support, Client roles with middleware
- **Complete Database Schema** - 35+ tables covering all WHMCS functionality

### Core Modules
- **Products & Services** - Product groups, configurable options, multi-cycle pricing
- **Billing & Invoicing** - Invoices, transactions, credit system, promo codes, tax rules
- **Domain Management** - Registrar integration, TLD pricing, DNS records, WHOIS contacts
- **Support Tickets** - Departments, priorities, canned responses, internal notes, tags
- **Server Management** - Server groups, auto-provisioning support (cPanel/Plesk/DirectAdmin)
- **Order System** - Shopping cart, order processing, auto-setup on payment
- **Email Templates** - Customizable templates with variable substitution
- **Affiliate System** - Referral tracking, commission management
- **Knowledge Base** - Categories, articles, helpful voting
- **Announcements** - Company news & updates

## Tech Stack
- **Backend**: Laravel 11 (PHP 8.2+)
- **Database**: MySQL 8.0+
- **Cache/Queue**: Redis
- **Frontend**: Blade + Tailwind CSS
- **PDF**: DomPDF
- **Payments**: Stripe, PayPal (planned)

## Installation

```bash
# Clone the project
git clone <repo-url> whmcs-clone
cd whmcs-clone

# Install dependencies
composer install

# Configure environment
cp .env.example .env
php artisan key:generate

# Edit .env with your database credentials
nano .env

# Run migrations & seed
php artisan migrate
php artisan db:seed

# Start development server
php artisan serve
```

## Default Login Credentials

| Role | Email | Password |
|------|-------|----------|
| Admin | admin@example.com | password |
| Client | client@example.com | password |

## Project Structure

```
app/
├── Http/
│   ├── Controllers/
│   │   ├── Admin/          # Admin panel controllers
│   │   ├── Client/         # Client area controllers
│   │   ├── Auth/           # Authentication
│   │   └── Webhook/        # Payment webhooks
│   └── Middleware/          # Admin & Client middleware
├── Models/                  # Eloquent models (20+)
├── Services/                # Business logic services
└── Enums/                   # Status enums
database/
├── migrations/              # 7 migration files, 35+ tables
└── seeders/                 # Sample data seeder
resources/views/
├── admin/                   # Admin panel views
│   ├── layouts/             # Admin layout with sidebar
│   ├── dashboard/           # Dashboard with stats
│   ├── clients/             # Client management
│   ├── products/            # Product management
│   ├── invoices/            # Invoice management
│   └── tickets/             # Ticket management
├── client/                  # Client portal views
│   ├── layouts/             # Client layout with navbar
│   ├── dashboard/           # Client dashboard
│   ├── services/            # Service management
│   ├── invoices/            # Invoice viewing/payment
│   └── tickets/             # Ticket submission
└── auth/                    # Login & Register
routes/
└── web.php                  # All routes (admin + client + webhooks)
```

## Database Tables

| Category | Tables |
|----------|--------|
| Users | users, password_reset_tokens, sessions |
| Products | product_groups, products, product_pricing, config_option_groups, config_options, config_option_values |
| Servers | server_groups, servers, product_server_group, product_config_group |
| Orders | orders, services, service_addons |
| Billing | invoices, invoice_items, transactions, payment_methods, currencies, promotions, tax_rules, credit_log |
| Domains | domain_registrars, tld_pricing, domains, domain_dns_records, domain_contacts |
| Support | departments, tickets, ticket_replies, ticket_attachments, canned_responses, ticket_tags, kb_categories, kb_articles |
| System | email_templates, email_log, activity_log, settings, announcements, cron_log, affiliates, affiliate_referrals |

## Admin Panel Routes

- `GET /admin` - Dashboard
- `GET /admin/clients` - Client management
- `GET /admin/products` - Product management
- `GET /admin/services` - Active services
- `GET /admin/servers` - Server management
- `GET /admin/invoices` - Invoice management
- `GET /admin/tickets` - Support tickets
- `GET /admin/orders` - Order management
- `GET /admin/settings` - System settings

## Client Portal Routes

- `GET /client` - Client dashboard
- `GET /client/services` - My services
- `GET /client/invoices` - My invoices
- `GET /client/tickets` - Support tickets
- `GET /client/domains` - My domains
- `GET /client/order` - Order new services
- `GET /client/profile` - Edit profile

## Next Steps (TODO)

### Phase 2 - Payment Gateways
- [ ] Stripe integration (checkout, webhooks, saved cards)
- [ ] PayPal integration
- [ ] Bank transfer support
- [ ] Auto-billing / recurring charges

### Phase 3 - Provisioning
- [ ] cPanel/WHM API integration
- [ ] Plesk API integration
- [ ] DirectAdmin API integration
- [ ] Auto-create/suspend/terminate accounts

### Phase 4 - Domain Registrars
- [ ] Enom API integration
- [ ] Namecheap API integration
- [ ] ResellerClub API integration
- [ ] Domain search & availability check

### Phase 5 - Advanced Features
- [ ] Email piping for tickets
- [ ] Invoice PDF generation
- [ ] Cron automation (billing, reminders, suspensions)
- [ ] REST API for integrations
- [ ] Report generation
- [ ] Multi-language support

## License

MIT
