<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\{Invoice, Order, Service, Ticket, User, Domain, Transaction};
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index()
    {
        $monthlyRevenue = Transaction::where('type', 'payment')->where('status', 'completed')
            ->where('created_at', '>=', now()->startOfMonth())->sum('amount');

        $revenueChart = Transaction::where('type', 'payment')->where('status', 'completed')
            ->where('created_at', '>=', now()->subMonths(12))
            ->select(DB::raw('DATE_FORMAT(created_at, "%Y-%m") as month'), DB::raw('SUM(amount) as total'))
            ->groupBy('month')->orderBy('month')->pluck('total', 'month');

        $stats = [
            'total_clients' => User::clients()->count(),
            'active_services' => Service::where('status', 'active')->count(),
            'active_domains' => Domain::where('status', 'active')->count(),
            'pending_orders' => Order::where('status', 'pending')->count(),
            'open_tickets' => Ticket::open()->count(),
            'overdue_invoices' => Invoice::overdue()->count(),
            'monthly_revenue' => $monthlyRevenue,
            'unpaid_total' => Invoice::unpaid()->sum('balance'),
        ];

        $recentOrders = Order::with('user')->latest()->limit(5)->get();
        $recentTickets = Ticket::with(['user', 'department'])->latest()->limit(5)->get();
        $recentInvoices = Invoice::with('user')->latest()->limit(5)->get();

        return view('admin.dashboard.index', compact('stats', 'revenueChart', 'recentOrders', 'recentTickets', 'recentInvoices'));
    }
}
