<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\{Domain, DomainPricing};
use Illuminate\Http\Request;

class DomainController extends Controller
{
    public function index(Request $request)
    {
        $domains = Domain::with('user')
            ->when($request->status, fn($q, $s) => $q->where('status', $s))
            ->when($request->search, fn($q, $s) => $q->where('domain_name', 'like', "%{$s}%"))
            ->latest()
            ->paginate(25);
        $pricing = DomainPricing::orderBy('sort_order')->get();
        return view('admin.domains.index', compact('domains', 'pricing'));
    }

    public function show(Domain $domain)
    {
        $domain->load('user');
        return view('admin.domains.show', compact('domain'));
    }
}
