<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    public function index(Request $request)
    {
        $orders = Order::with('user')
            ->when($request->status, fn($q, $s) => $q->where('status', $s))
            ->latest()->paginate(25);
        return view('admin.orders.index', compact('orders'));
    }

    public function show(Order $order)
    {
        $order->load(['user', 'services.product', 'domains', 'invoice']);
        return view('admin.orders.show', compact('order'));
    }

    public function accept(Order $order)
    {
        $order->update(['status' => 'active']);
        foreach ($order->services as $service) {
            if ($service->isPending()) {
                $service->update(['status' => 'active', 'registration_date' => now()]);
            }
        }
        return back()->with('success', 'Order accepted.');
    }

    public function cancel(Order $order)
    {
        $order->update(['status' => 'cancelled']);
        $order->services()->update(['status' => 'cancelled']);
        return back()->with('success', 'Order cancelled.');
    }
}
