<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\{Transaction, User, Service, Invoice, Ticket};
use Carbon\Carbon;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function index() { return view('admin.reports.index'); }

    public function income(Request $request)
    {
        $period = $request->input('period', 'monthly');
        $year = $request->input('year', date('Y'));

        $data = [];
        for ($m = 1; $m <= 12; $m++) {
            $data[] = [
                'month' => Carbon::create($year, $m)->format('M'),
                'income' => Transaction::where('type', 'payment')->where('status', 'completed')
                    ->whereYear('created_at', $year)->whereMonth('created_at', $m)->sum('amount'),
                'refunds' => Transaction::where('type', 'refund')
                    ->whereYear('created_at', $year)->whereMonth('created_at', $m)->sum('amount'),
            ];
        }
        return view('admin.reports.income', compact('data', 'year'));
    }

    public function clients(Request $request)
    {
        $newClients = User::clients()
            ->selectRaw('DATE_FORMAT(created_at, "%Y-%m") as month, COUNT(*) as count')
            ->groupBy('month')->orderBy('month', 'desc')->limit(12)->get();
        return view('admin.reports.clients', compact('newClients'));
    }

    public function products()
    {
        $products = Service::selectRaw('product_id, COUNT(*) as total, SUM(CASE WHEN status="active" THEN 1 ELSE 0 END) as active_count')
            ->with('product:id,name')->groupBy('product_id')->get();
        return view('admin.reports.products', compact('products'));
    }
}
