<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\{Server, ServerGroup};
use Illuminate\Http\Request;

class ServerController extends Controller
{
    public function index()
    {
        $servers = Server::with('serverGroup')->withCount('services')->orderBy('sort_order')->get();
        return view('admin.servers.index', compact('servers'));
    }

    public function create()
    {
        $serverGroups = ServerGroup::all();
        return view('admin.servers.create', compact('serverGroups'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|max:200', 'hostname' => 'required|max:255',
            'ip_address' => 'required|max:45', 'module' => 'required|max:100',
            'server_group_id' => 'nullable|exists:server_groups,id',
            'username' => 'nullable|max:100', 'password' => 'nullable',
            'access_hash' => 'nullable', 'port' => 'integer',
            'nameserver1' => 'nullable|max:255', 'nameserver2' => 'nullable|max:255',
            'max_accounts' => 'integer|min:0',
        ]);
        Server::create($data);
        return redirect()->route('admin.servers.index')->with('success', 'Server created.');
    }

    public function edit(Server $server) { return view('admin.servers.edit', compact('server')); }

    public function update(Request $request, Server $server)
    {
        $server->update($request->validated());
        return back()->with('success', 'Server updated.');
    }

    public function testConnection(Server $server)
    {
        // TODO: Implement module-specific connection test
        return back()->with('info', 'Connection test not yet implemented for module: ' . $server->module);
    }
}
