<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\{Service, Product, Server, User};
use App\Services\ProvisioningService;
use Illuminate\Http\Request;

class ServiceController extends Controller
{
    public function index(Request $request)
    {
        $services = Service::with(['user', 'product', 'server'])
            ->when($request->status, fn($q, $s) => $q->where('status', $s))
            ->when($request->search, fn($q, $s) => $q->where('domain', 'like', "%{$s}%")
                ->orWhereHas('user', fn($u) => $u->search($s)))
            ->latest()
            ->paginate(25);
        return view('admin.services.index', compact('services'));
    }

    public function show(Service $service)
    {
        $service->load(['user', 'product', 'server', 'addons', 'order']);
        return view('admin.services.show', compact('service'));
    }

    public function suspend(Request $request, Service $service)
    {
        $request->validate(['reason' => 'required|max:255']);
        $service->update(['status' => 'suspended', 'suspension_reason' => $request->reason]);
        // TODO: Call provisioning module to suspend on server
        return back()->with('success', 'Service suspended.');
    }

    public function unsuspend(Service $service)
    {
        $service->update(['status' => 'active', 'suspension_reason' => null]);
        return back()->with('success', 'Service unsuspended.');
    }

    public function terminate(Service $service)
    {
        $service->update(['status' => 'terminated', 'termination_date' => now()]);
        if ($service->server) {
            $service->server->decrement('active_accounts');
        }
        return back()->with('success', 'Service terminated.');
    }
}
