<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\{Setting, PaymentGateway, EmailTemplate};
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    public function index()
    {
        $settings = Setting::all()->groupBy('group');
        return view('admin.settings.index', compact('settings'));
    }

    public function update(Request $request)
    {
        foreach ($request->settings as $key => $value) {
            Setting::set($key, $value);
        }
        return back()->with('success', 'Settings updated.');
    }

    public function gateways()
    {
        $gateways = PaymentGateway::orderBy('sort_order')->get();
        return view('admin.settings.gateways', compact('gateways'));
    }

    public function updateGateway(Request $request, PaymentGateway $gateway)
    {
        $gateway->update($request->only(['config', 'is_active', 'sort_order']));
        return back()->with('success', 'Gateway updated.');
    }

    public function emailTemplates()
    {
        $templates = EmailTemplate::orderBy('type')->get();
        return view('admin.settings.email-templates', compact('templates'));
    }

    public function updateEmailTemplate(Request $request, EmailTemplate $template)
    {
        $template->update($request->only(['subject', 'body', 'is_active']));
        return back()->with('success', 'Template updated.');
    }
}
