<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\{Ticket, TicketReply, TicketDepartment, User};
use Illuminate\Http\Request;

class SupportController extends Controller
{
    public function index(Request $request)
    {
        $tickets = Ticket::with(['user', 'department', 'assignedAdmin'])
            ->when($request->status, fn($q, $s) => $q->where('status', $s))
            ->when($request->department, fn($q, $d) => $q->where('department_id', $d))
            ->when($request->priority, fn($q, $p) => $q->where('priority', $p))
            ->when($request->search, fn($q, $s) => $q->where('subject', 'like', "%{$s}%"))
            ->latest('last_reply_at')
            ->paginate(25);
        $departments = TicketDepartment::where('is_active', true)->get();
        $admins = User::whereIn('role', ['admin', 'support'])->get();
        return view('admin.support.index', compact('tickets', 'departments', 'admins'));
    }

    public function show(Ticket $ticket)
    {
        $ticket->load(['user', 'department', 'replies.user', 'service.product']);
        return view('admin.support.show', compact('ticket'));
    }

    public function reply(Request $request, Ticket $ticket)
    {
        $request->validate(['message' => 'required|string']);
        $ticket->replies()->create([
            'user_id' => auth()->id(),
            'message' => $request->message,
            'is_admin' => true,
        ]);
        $ticket->update(['status' => 'answered', 'last_reply_at' => now()]);
        return back()->with('success', 'Reply sent.');
    }

    public function close(Ticket $ticket)
    {
        $ticket->update(['status' => 'closed']);
        return back()->with('success', 'Ticket closed.');
    }

    public function assign(Request $request, Ticket $ticket)
    {
        $ticket->update(['assigned_to' => $request->admin_id]);
        return back()->with('success', 'Ticket assigned.');
    }
}
