<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\{Ticket, TicketReply, Department};
use Illuminate\Http\Request;

class TicketController extends Controller
{
    public function index(Request $request)
    {
        $tickets = Ticket::with(['user', 'department', 'assignedTo'])
            ->when($request->status, fn($q, $s) => $q->where('status', $s))
            ->when($request->department, fn($q, $d) => $q->where('department_id', $d))
            ->when($request->priority, fn($q, $p) => $q->where('priority', $p))
            ->latest()
            ->paginate(25);
        $departments = Department::orderBy('sort_order')->get();
        return view('admin.tickets.index', compact('tickets', 'departments'));
    }

    public function show(Ticket $ticket)
    {
        $ticket->load(['user', 'department', 'replies.user', 'attachments', 'service']);
        $cannedResponses = \App\Models\CannedResponse::orderBy('sort_order')->get();
        return view('admin.tickets.show', compact('ticket', 'cannedResponses'));
    }

    public function reply(Request $request, Ticket $ticket)
    {
        $request->validate(['message' => 'required']);
        $ticket->replies()->create([
            'user_id' => auth()->id(), 'message' => $request->message,
            'is_admin_reply' => true, 'is_internal_note' => $request->boolean('internal'),
            'ip_address' => $request->ip(),
        ]);
        $status = $request->boolean('internal') ? $ticket->status : 'answered';
        $ticket->update(['status' => $status, 'last_reply_at' => now()]);
        if (!$ticket->first_response_at) {
            $ticket->update(['first_response_at' => now()]);
        }
        return back()->with('success', 'Reply sent.');
    }

    public function close(Ticket $ticket)
    {
        $ticket->update(['status' => 'closed']);
        return back()->with('success', 'Ticket closed.');
    }
}
