<?php
namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;

class DashboardController extends Controller
{
    public function index()
    {
        $user = auth()->user();
        $stats = [
            'active_services' => $user->services()->where('status', 'active')->count(),
            'active_domains' => $user->domains()->where('status', 'active')->count(),
            'unpaid_invoices' => $user->invoices()->whereIn('status', ['unpaid', 'overdue'])->count(),
            'open_tickets' => $user->tickets()->whereNotIn('status', ['closed'])->count(),
            'credit_balance' => $user->credit_balance,
        ];

        $recentInvoices = $user->invoices()->latest()->limit(5)->get();
        $recentTickets = $user->tickets()->with('department')->latest()->limit(5)->get();
        $services = $user->services()->with('product')->where('status', 'active')->get();
        $domains = $user->domains()->where('status', 'active')->orderBy('expiry_date')->limit(5)->get();

        return view('client.dashboard.index', compact('stats', 'recentInvoices', 'recentTickets', 'services', 'domains'));
    }
}
