<?php
namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use App\Models\Domain;

class DomainController extends Controller
{
    public function index()
    {
        $domains = auth()->user()->domains()->latest()->paginate(20);
        return view('client.domains.index', compact('domains'));
    }

    public function show(Domain $domain)
    {
        abort_if($domain->user_id !== auth()->id(), 403);
        $domain->load('dnsRecords');
        return view('client.domains.show', compact('domain'));
    }
}
