<?php
namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use App\Models\Invoice;

class InvoiceController extends Controller
{
    public function index()
    {
        $invoices = auth()->user()->invoices()->latest()->paginate(20);
        return view('client.invoices.index', compact('invoices'));
    }

    public function show(Invoice $invoice)
    {
        abort_if($invoice->user_id !== auth()->id(), 403);
        $invoice->load('items');
        return view('client.invoices.show', compact('invoice'));
    }

    public function pay(Invoice $invoice)
    {
        abort_if($invoice->user_id !== auth()->id(), 403);
        // TODO: Redirect to payment gateway (Stripe Checkout, PayPal, etc.)
        return redirect()->route('client.invoices.show', $invoice)->with('info', 'Payment processing not yet configured.');
    }
}
