<?php
namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class ProfileController extends Controller
{
    public function edit()
    {
        return view('client.profile.edit', ['user' => auth()->user()]);
    }

    public function update(Request $request)
    {
        $user = auth()->user();
        $data = $request->validate([
            'first_name' => 'required|max:100', 'last_name' => 'required|max:100',
            'email' => 'required|email|unique:users,email,' . $user->id,
            'company_name' => 'nullable|max:200', 'phone' => 'nullable|max:30',
            'address1' => 'nullable|max:255', 'city' => 'nullable|max:100',
            'state' => 'nullable|max:100', 'postcode' => 'nullable|max:20',
            'country' => 'required|size:2',
        ]);
        $user->update($data);
        return back()->with('success', 'Profile updated.');
    }
}
