<?php
namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use App\Models\Service;

class ServiceController extends Controller
{
    public function index()
    {
        $services = auth()->user()->services()->with('product')->latest()->paginate(20);
        return view('client.services.index', compact('services'));
    }

    public function show(Service $service)
    {
        abort_if($service->user_id !== auth()->id(), 403);
        $service->load(['product', 'server', 'addons']);
        return view('client.services.show', compact('service'));
    }

    public function requestCancel(Service $service)
    {
        abort_if($service->user_id !== auth()->id(), 403);
        $service->update(['status' => 'cancelled']);
        return back()->with('success', 'Cancellation request submitted.');
    }
}
