<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class ClientMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        if (!auth()->check()) {
            return redirect()->route('login');
        }
        // Admins can also access client area
        if (auth()->user()->isClient() || auth()->user()->isStaff()) {
            return $next($request);
        }
        abort(403);
    }
}
