<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Department extends Model
{
    protected $fillable = ['name', 'email', 'description', 'clients_only', 'is_hidden', 'sort_order'];
    protected function casts(): array { return ['clients_only' => 'boolean', 'is_hidden' => 'boolean']; }

    public function tickets() { return $this->hasMany(Ticket::class); }
    public function openTickets() { return $this->tickets()->whereNotIn('status', ['closed']); }
}
