<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Domain extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'user_id', 'order_id', 'domain_registrar_id', 'domain', 'sld', 'tld',
        'type', 'status', 'registration_date', 'expiry_date', 'next_due_date',
        'registration_period', 'recurring_amount', 'currency', 'auto_renew',
        'nameserver1', 'nameserver2', 'nameserver3', 'nameserver4',
        'id_protection', 'epp_code', 'dns_management', 'email_forwarding', 'admin_notes',
    ];

    protected function casts(): array
    {
        return [
            'registration_date' => 'date', 'expiry_date' => 'date', 'next_due_date' => 'date',
            'auto_renew' => 'boolean', 'id_protection' => 'boolean',
            'epp_code' => 'encrypted', 'recurring_amount' => 'decimal:2',
        ];
    }

    public function user() { return $this->belongsTo(User::class); }
    public function registrar() { return $this->belongsTo(DomainRegistrar::class, 'domain_registrar_id'); }
    public function dnsRecords() { return $this->hasMany(DomainDnsRecord::class); }
    public function contacts() { return $this->hasMany(DomainContact::class); }

    public function scopeActive($q) { return $q->where('status', 'active'); }
    public function scopeExpiringSoon($q, int $days = 30) {
        return $q->where('status', 'active')->where('expiry_date', '<=', now()->addDays($days));
    }
}
