<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DomainRegistrar extends Model
{
    protected $fillable = ['name', 'module', 'config', 'is_active', 'sort_order'];
    protected function casts(): array { return ['config' => 'encrypted:array', 'is_active' => 'boolean']; }
    public function domains() { return $this->hasMany(Domain::class); }
    public function tldPricing() { return $this->hasMany(TldPricing::class); }
}
