<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class InvoiceItem extends Model
{
    protected $fillable = [
        'invoice_id', 'service_id', 'domain_id', 'type', 'description',
        'amount', 'tax_amount', 'is_taxed', 'period_start', 'period_end',
    ];
    protected function casts(): array
    {
        return ['amount' => 'decimal:2', 'is_taxed' => 'boolean', 'period_start' => 'date', 'period_end' => 'date'];
    }

    public function invoice() { return $this->belongsTo(Invoice::class); }
    public function service() { return $this->belongsTo(Service::class); }
}
