<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Order extends Model
{
    protected $fillable = [
        'order_number', 'user_id', 'invoice_id', 'status', 'amount',
        'currency', 'payment_method', 'ip_address', 'notes', 'promo_code',
    ];

    protected static function boot()
    {
        parent::boot();
        static::creating(function ($order) {
            $order->order_number = $order->order_number ?? strtoupper(Str::random(10));
        });
    }

    public function user() { return $this->belongsTo(User::class); }
    public function invoice() { return $this->belongsTo(Invoice::class); }
    public function services() { return $this->hasMany(Service::class); }
    public function domains() { return $this->hasMany(Domain::class); }
}
