<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class PaymentGateway extends Model
{
    protected $fillable = ['name', 'slug', 'module', 'config', 'is_active', 'sort_order'];
    protected $casts = ['config' => 'encrypted:array', 'is_active' => 'boolean'];

    public function scopeActive($query) { return $query->where('is_active', true); }
}
