<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'product_group_id', 'name', 'slug', 'type', 'description', 'features',
        'module', 'module_config', 'stock_quantity', 'stock_enabled',
        'is_active', 'is_hidden', 'auto_setup', 'auto_setup_on',
        'require_domain', 'upgrade_product_ids', 'configurable_options',
        'welcome_email_template', 'sort_order',
    ];

    protected function casts(): array
    {
        return [
            'features' => 'array', 'module_config' => 'array',
            'upgrade_product_ids' => 'array', 'configurable_options' => 'array',
            'is_active' => 'boolean', 'is_hidden' => 'boolean',
            'auto_setup' => 'boolean', 'require_domain' => 'boolean',
        ];
    }

    public function group() { return $this->belongsTo(ProductGroup::class, 'product_group_id'); }
    public function pricing() { return $this->hasMany(ProductPricing::class); }
    public function services() { return $this->hasMany(Service::class); }
    public function serverGroups() { return $this->belongsToMany(ServerGroup::class, 'product_server_group'); }
    public function configOptionGroups() { return $this->belongsToMany(ConfigOptionGroup::class, 'product_config_group'); }

    public function getMonthlyPrice(string $currency = 'USD'): ?float
    {
        return $this->pricing()->where('currency', $currency)->where('billing_cycle', 'monthly')->value('price');
    }

    public function scopeActive($q) { return $q->where('is_active', true)->where('is_hidden', false); }
    public function scopeByType($q, string $type) { return $q->where('type', $type); }
}
