<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductGroup extends Model
{
    protected $fillable = ['name', 'slug', 'description', 'headline', 'sort_order', 'is_hidden'];
    protected function casts(): array { return ['is_hidden' => 'boolean']; }

    public function products() { return $this->hasMany(Product::class)->orderBy('sort_order'); }
    public function activeProducts() { return $this->products()->where('is_active', true)->where('is_hidden', false); }
}
