<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductPricing extends Model
{
    protected $table = 'product_pricing';
    protected $fillable = ['product_id', 'currency', 'billing_cycle', 'price', 'setup_fee', 'is_enabled'];
    protected function casts(): array { return ['price' => 'decimal:2', 'setup_fee' => 'decimal:2', 'is_enabled' => 'boolean']; }

    public function product() { return $this->belongsTo(Product::class); }
}
