<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class PromoCode extends Model
{
    protected $fillable = [
        'code', 'type', 'value', 'applicable_products', 'applicable_cycles',
        'max_uses', 'uses', 'start_date', 'expiry_date', 'recurring', 'is_active',
    ];
    protected $casts = [
        'applicable_products' => 'array', 'applicable_cycles' => 'array',
        'start_date' => 'date', 'expiry_date' => 'date',
        'recurring' => 'boolean', 'is_active' => 'boolean',
    ];

    public function isValid(): bool
    {
        if (!$this->is_active) return false;
        if ($this->max_uses > 0 && $this->uses >= $this->max_uses) return false;
        if ($this->start_date && now()->lt($this->start_date)) return false;
        if ($this->expiry_date && now()->gt($this->expiry_date)) return false;
        return true;
    }

    public function calculateDiscount(float $amount): float
    {
        return match($this->type) {
            'percentage' => $amount * ($this->value / 100),
            'fixed' => min($this->value, $amount),
            'override' => max(0, $amount - $this->value),
            'free_setup' => 0,
            default => 0,
        };
    }
}
