<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Server extends Model
{
    protected $fillable = [
        'server_group_id', 'name', 'hostname', 'ip_address', 'assigned_ips',
        'nameserver1', 'nameserver2', 'nameserver3', 'nameserver4',
        'module', 'username', 'password', 'access_hash', 'port', 'use_ssl',
        'max_accounts', 'active_accounts', 'is_active', 'is_disabled', 'sort_order',
    ];

    protected function casts(): array
    {
        return [
            'assigned_ips' => 'array', 'password' => 'encrypted',
            'access_hash' => 'encrypted', 'is_active' => 'boolean', 'is_disabled' => 'boolean',
        ];
    }

    public function serverGroup() { return $this->belongsTo(ServerGroup::class); }
    public function services() { return $this->hasMany(Service::class); }

    public function hasCapacity(): bool
    {
        return $this->max_accounts === 0 || $this->active_accounts < $this->max_accounts;
    }
}
