<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ServerGroup extends Model
{
    protected $fillable = ['name', 'fill_type'];

    public function servers() { return $this->hasMany(Server::class); }
    public function products() { return $this->belongsToMany(Product::class, 'product_server_group'); }

    public function getAvailableServer(): ?Server
    {
        $query = $this->servers()->where('is_active', true)->where('is_disabled', false);
        if ($this->fill_type === 'fill') {
            return $query->orderBy('active_accounts', 'asc')->first();
        }
        return $query->inRandomOrder()->first(); // round_robin simplified
    }
}
