<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Service extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'user_id', 'order_id', 'product_id', 'server_id', 'domain', 'status',
        'suspension_reason', 'username', 'password', 'dedicated_ip', 'assigned_ips',
        'billing_cycle', 'recurring_amount', 'currency', 'registration_date',
        'next_due_date', 'termination_date', 'module_data',
        'disk_usage', 'disk_limit', 'bandwidth_usage', 'bandwidth_limit', 'admin_notes',
    ];

    protected function casts(): array
    {
        return [
            'password' => 'encrypted', 'module_data' => 'array',
            'recurring_amount' => 'decimal:2',
            'registration_date' => 'date', 'next_due_date' => 'date', 'termination_date' => 'date',
        ];
    }

    public function user() { return $this->belongsTo(User::class); }
    public function product() { return $this->belongsTo(Product::class); }
    public function server() { return $this->belongsTo(Server::class); }
    public function order() { return $this->belongsTo(Order::class); }
    public function addons() { return $this->hasMany(ServiceAddon::class); }
    public function tickets() { return $this->hasMany(Ticket::class); }

    public function isActive(): bool { return $this->status === 'active'; }
    public function isPending(): bool { return $this->status === 'pending'; }
    public function isSuspended(): bool { return $this->status === 'suspended'; }

    public function scopeActive($q) { return $q->where('status', 'active'); }
    public function scopeDueBefore($q, $date) { return $q->where('next_due_date', '<=', $date); }
}
