<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ServiceAddon extends Model
{
    protected $fillable = [
        'service_id', 'product_id', 'name', 'recurring_amount',
        'setup_fee', 'billing_cycle', 'status', 'next_due_date',
    ];
    protected function casts(): array { return ['next_due_date' => 'date', 'recurring_amount' => 'decimal:2']; }

    public function service() { return $this->belongsTo(Service::class); }
    public function product() { return $this->belongsTo(Product::class); }
}
