<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TicketReply extends Model
{
    protected $fillable = ['ticket_id', 'user_id', 'message', 'is_admin_reply', 'is_internal_note', 'ip_address'];
    protected function casts(): array { return ['is_admin_reply' => 'boolean', 'is_internal_note' => 'boolean']; }

    public function ticket() { return $this->belongsTo(Ticket::class); }
    public function user() { return $this->belongsTo(User::class); }
    public function attachments() { return $this->hasMany(TicketAttachment::class); }
}
