<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TldPricing extends Model
{
    protected $table = 'tld_pricing';
    protected $fillable = [
        'tld', 'domain_registrar_id', 'currency',
        'register_1yr', 'register_2yr', 'register_3yr', 'register_5yr', 'register_10yr',
        'transfer_price', 'renew_1yr', 'renew_2yr', 'renew_3yr', 'renew_5yr', 'renew_10yr',
        'grace_fee', 'redemption_fee', 'id_protection_price', 'id_protection_available',
        'epp_required', 'min_years', 'max_years', 'is_active', 'sort_order',
    ];
    public function registrar() { return $this->belongsTo(DomainRegistrar::class, 'domain_registrar_id'); }
}
