<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    protected $fillable = [
        'user_id', 'invoice_id', 'transaction_id', 'gateway', 'type',
        'amount', 'fee', 'currency', 'status', 'description', 'gateway_response',
    ];
    protected function casts(): array { return ['amount' => 'decimal:2', 'fee' => 'decimal:2', 'gateway_response' => 'array']; }

    public function user() { return $this->belongsTo(User::class); }
    public function invoice() { return $this->belongsTo(Invoice::class); }
}
