<?php
namespace Database\Seeders;

use App\Models\{User, Product, ProductGroup, ProductPricing, Server, ServerGroup, Department, Currency, Setting, EmailTemplate};
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        User::create(['first_name'=>'Admin','last_name'=>'User','email'=>'admin@example.com','password'=>Hash::make('password'),'role'=>'admin','country'=>'US']);
        User::create(['first_name'=>'John','last_name'=>'Doe','email'=>'client@example.com','password'=>Hash::make('password'),'role'=>'client','company_name'=>'Doe Enterprises','country'=>'US','phone'=>'+1-555-0100']);

        Currency::create(['code'=>'USD','name'=>'US Dollar','symbol'=>'$','is_default'=>true]);
        Currency::create(['code'=>'EUR','name'=>'Euro','symbol'=>'€','exchange_rate'=>0.92]);

        $shared = ProductGroup::create(['name'=>'Shared Hosting','slug'=>'shared-hosting','description'=>'Affordable shared hosting','sort_order'=>1]);
        $vps = ProductGroup::create(['name'=>'VPS Hosting','slug'=>'vps-hosting','description'=>'Virtual private servers','sort_order'=>2]);

        $p1 = Product::create(['product_group_id'=>$shared->id,'name'=>'Starter','slug'=>'starter','type'=>'hosting','description'=>'Perfect for small websites','features'=>['10 GB SSD','100 GB BW','1 Website','Free SSL','cPanel'],'module'=>'cpanel','auto_setup'=>true,'require_domain'=>true,'sort_order'=>1]);
        ProductPricing::create(['product_id'=>$p1->id,'billing_cycle'=>'monthly','price'=>4.99]);
        ProductPricing::create(['product_id'=>$p1->id,'billing_cycle'=>'annually','price'=>49.99]);

        $p2 = Product::create(['product_group_id'=>$shared->id,'name'=>'Business','slug'=>'business','type'=>'hosting','description'=>'For growing businesses','features'=>['50 GB SSD','Unlimited BW','10 Websites','Free SSL','cPanel','Daily Backups'],'module'=>'cpanel','auto_setup'=>true,'require_domain'=>true,'sort_order'=>2]);
        ProductPricing::create(['product_id'=>$p2->id,'billing_cycle'=>'monthly','price'=>9.99]);
        ProductPricing::create(['product_id'=>$p2->id,'billing_cycle'=>'annually','price'=>99.99]);

        $p3 = Product::create(['product_group_id'=>$shared->id,'name'=>'Enterprise','slug'=>'enterprise','type'=>'hosting','features'=>['Unlimited SSD','Unlimited BW','Unlimited Websites','Free SSL','Priority Support'],'module'=>'cpanel','auto_setup'=>true,'require_domain'=>true,'sort_order'=>3]);
        ProductPricing::create(['product_id'=>$p3->id,'billing_cycle'=>'monthly','price'=>19.99]);
        ProductPricing::create(['product_id'=>$p3->id,'billing_cycle'=>'annually','price'=>199.99]);

        $v1 = Product::create(['product_group_id'=>$vps->id,'name'=>'VPS 1','slug'=>'vps-1','type'=>'vps','description'=>'2 vCPU, 2GB RAM, 40GB SSD','features'=>['2 vCPU','2 GB RAM','40 GB SSD','2 TB BW','Root Access'],'sort_order'=>1]);
        ProductPricing::create(['product_id'=>$v1->id,'billing_cycle'=>'monthly','price'=>19.99]);

        $sg = ServerGroup::create(['name'=>'Primary Servers','fill_type'=>'fill']);
        Server::create(['server_group_id'=>$sg->id,'name'=>'Web Server 1','hostname'=>'server1.example.com','ip_address'=>'192.168.1.1','module'=>'cpanel','port'=>2087,'nameserver1'=>'ns1.example.com','nameserver2'=>'ns2.example.com','max_accounts'=>500]);

        Department::create(['name'=>'Sales','email'=>'sales@example.com','sort_order'=>1]);
        Department::create(['name'=>'Technical Support','email'=>'support@example.com','sort_order'=>2]);
        Department::create(['name'=>'Billing','email'=>'billing@example.com','sort_order'=>3]);

        foreach ([
            ['group'=>'general','key'=>'company_name','value'=>'HostBill Clone'],
            ['group'=>'general','key'=>'company_email','value'=>'info@example.com'],
            ['group'=>'billing','key'=>'invoice_due_days','value'=>'7','type'=>'integer'],
            ['group'=>'billing','key'=>'auto_suspend_days','value'=>'3','type'=>'integer'],
            ['group'=>'billing','key'=>'auto_terminate_days','value'=>'14','type'=>'integer'],
            ['group'=>'support','key'=>'auto_close_hours','value'=>'168','type'=>'integer'],
        ] as $s) { Setting::create($s); }

        foreach ([
            ['slug'=>'invoice_created','name'=>'Invoice Created','type'=>'invoice','subject'=>'New Invoice #{invoice_number}','body'=>'<p>Dear {client_name},</p><p>A new invoice #{invoice_number} for ${total}. Due: {due_date}.</p>'],
            ['slug'=>'invoice_paid','name'=>'Invoice Paid','type'=>'invoice','subject'=>'Payment Received - #{invoice_number}','body'=>'<p>Dear {client_name},</p><p>Payment of ${amount} received for #{invoice_number}.</p>'],
            ['slug'=>'service_welcome','name'=>'Service Welcome','type'=>'product','subject'=>'Your service is ready!','body'=>'<p>Dear {client_name},</p><p>{product_name} activated! Domain: {domain}</p>'],
            ['slug'=>'ticket_opened','name'=>'Ticket Opened','type'=>'support','subject'=>'Ticket #{ticket_number}','body'=>'<p>Dear {client_name},</p><p>Ticket #{ticket_number} opened. We will respond shortly.</p>'],
        ] as $t) { EmailTemplate::create($t); }
    }
}
