@extends('admin.layouts.app')
@section('title', 'Dashboard')

@section('content')
{{-- Stats Cards --}}
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <div class="bg-white rounded-xl shadow-sm border p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm text-gray-500">Monthly Revenue</p>
                <p class="text-2xl font-bold text-gray-900">${{ number_format($stats['monthly_revenue'], 2) }}</p>
            </div>
            <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
            </div>
        </div>
    </div>
    <div class="bg-white rounded-xl shadow-sm border p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm text-gray-500">Active Services</p>
                <p class="text-2xl font-bold text-gray-900">{{ $stats['active_services'] }}</p>
            </div>
            <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 12h14M5 12a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v4a2 2 0 01-2 2"/></svg>
            </div>
        </div>
    </div>
    <div class="bg-white rounded-xl shadow-sm border p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm text-gray-500">Open Tickets</p>
                <p class="text-2xl font-bold text-gray-900">{{ $stats['open_tickets'] }}</p>
            </div>
            <div class="w-12 h-12 bg-yellow-100 rounded-lg flex items-center justify-center">
                <svg class="w-6 h-6 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z"/></svg>
            </div>
        </div>
    </div>
    <div class="bg-white rounded-xl shadow-sm border p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm text-gray-500">Unpaid Invoices</p>
                <p class="text-2xl font-bold text-red-600">${{ number_format($stats['unpaid_total'], 2) }}</p>
            </div>
            <div class="w-12 h-12 bg-red-100 rounded-lg flex items-center justify-center">
                <svg class="w-6 h-6 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 16.5c-.77.833.192 2.5 1.732 2.5z"/></svg>
            </div>
        </div>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
    {{-- Recent Orders --}}
    <div class="bg-white rounded-xl shadow-sm border">
        <div class="p-6 border-b"><h3 class="font-semibold text-gray-900">Recent Orders</h3></div>
        <div class="divide-y">
            @forelse($recentOrders as $order)
            <div class="p-4 flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium">#{{ $order->order_number }}</p>
                    <p class="text-xs text-gray-500">{{ $order->user->full_name ?? 'N/A' }} · {{ $order->created_at->diffForHumans() }}</p>
                </div>
                <div class="flex items-center space-x-2">
                    <span class="text-sm font-medium">${{ number_format($order->amount, 2) }}</span>
                    <span class="px-2 py-0.5 text-xs rounded-full {{ $order->status === 'active' ? 'bg-green-100 text-green-800' : ($order->status === 'pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800') }}">
                        {{ ucfirst($order->status) }}
                    </span>
                </div>
            </div>
            @empty
            <p class="p-4 text-sm text-gray-500">No recent orders.</p>
            @endforelse
        </div>
    </div>

    {{-- Recent Tickets --}}
    <div class="bg-white rounded-xl shadow-sm border">
        <div class="p-6 border-b"><h3 class="font-semibold text-gray-900">Recent Tickets</h3></div>
        <div class="divide-y">
            @forelse($recentTickets as $ticket)
            <div class="p-4 flex items-center justify-between">
                <div>
                    <a href="{{ route('admin.tickets.show', $ticket) }}" class="text-sm font-medium text-indigo-600 hover:underline">{{ Str::limit($ticket->subject, 40) }}</a>
                    <p class="text-xs text-gray-500">{{ $ticket->user->full_name ?? $ticket->guest_name }} · {{ $ticket->department->name ?? '' }}</p>
                </div>
                <span class="px-2 py-0.5 text-xs rounded-full
                    {{ $ticket->status === 'open' ? 'bg-green-100 text-green-800' : '' }}
                    {{ $ticket->status === 'customer_reply' ? 'bg-red-100 text-red-800' : '' }}
                    {{ $ticket->status === 'answered' ? 'bg-blue-100 text-blue-800' : '' }}
                    {{ $ticket->status === 'closed' ? 'bg-gray-100 text-gray-800' : '' }}
                ">{{ ucfirst(str_replace('_', ' ', $ticket->status)) }}</span>
            </div>
            @empty
            <p class="p-4 text-sm text-gray-500">No recent tickets.</p>
            @endforelse
        </div>
    </div>

    {{-- Recent Invoices --}}
    <div class="bg-white rounded-xl shadow-sm border lg:col-span-2">
        <div class="p-6 border-b"><h3 class="font-semibold text-gray-900">Recent Invoices</h3></div>
        <table class="w-full">
            <thead class="bg-gray-50"><tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Invoice #</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Client</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Due Date</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
            </tr></thead>
            <tbody class="divide-y">
                @forelse($recentInvoices as $invoice)
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-4 text-sm"><a href="{{ route('admin.invoices.show', $invoice) }}" class="text-indigo-600 hover:underline">{{ $invoice->invoice_number }}</a></td>
                    <td class="px-6 py-4 text-sm">{{ $invoice->user->full_name ?? 'N/A' }}</td>
                    <td class="px-6 py-4 text-sm font-medium">${{ number_format($invoice->total, 2) }}</td>
                    <td class="px-6 py-4 text-sm">{{ $invoice->date_due?->format('M d, Y') }}</td>
                    <td class="px-6 py-4">
                        <span class="px-2 py-0.5 text-xs rounded-full {{ $invoice->status === 'paid' ? 'bg-green-100 text-green-800' : ($invoice->status === 'unpaid' ? 'bg-yellow-100 text-yellow-800' : 'bg-red-100 text-red-800') }}">
                            {{ ucfirst($invoice->status) }}
                        </span>
                    </td>
                </tr>
                @empty
                <tr><td colspan="5" class="px-6 py-4 text-sm text-gray-500 text-center">No invoices yet.</td></tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
