<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - {{ config('app.name') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>body{font-family:'Inter',sans-serif;}</style>
</head>
<body class="bg-gray-100 min-h-screen flex items-center justify-center py-12">
    <div class="w-full max-w-lg">
        <div class="text-center mb-8">
            <h1 class="text-3xl font-bold text-gray-900">{{ config('app.name', 'HostBill') }}</h1>
            <p class="text-gray-500 mt-2">Create your account</p>
        </div>
        <div class="bg-white rounded-2xl shadow-lg p-8">
            @if($errors->any())<div class="mb-4 p-3 bg-red-50 border border-red-200 text-red-700 rounded-lg text-sm">@foreach($errors->all() as $e)<p>{{ $e }}</p>@endforeach</div>@endif
            <form method="POST" action="{{ route('register') }}">
                @csrf
                <div class="grid grid-cols-2 gap-4 mb-4">
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">First Name *</label><input type="text" name="first_name" value="{{ old('first_name') }}" required class="w-full px-4 py-2.5 border rounded-lg focus:ring-2 focus:ring-indigo-500"></div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">Last Name *</label><input type="text" name="last_name" value="{{ old('last_name') }}" required class="w-full px-4 py-2.5 border rounded-lg focus:ring-2 focus:ring-indigo-500"></div>
                </div>
                <div class="mb-4"><label class="block text-sm font-medium text-gray-700 mb-1">Company (optional)</label><input type="text" name="company_name" value="{{ old('company_name') }}" class="w-full px-4 py-2.5 border rounded-lg focus:ring-2 focus:ring-indigo-500"></div>
                <div class="mb-4"><label class="block text-sm font-medium text-gray-700 mb-1">Email *</label><input type="email" name="email" value="{{ old('email') }}" required class="w-full px-4 py-2.5 border rounded-lg focus:ring-2 focus:ring-indigo-500"></div>
                <div class="mb-4"><label class="block text-sm font-medium text-gray-700 mb-1">Phone</label><input type="tel" name="phone" value="{{ old('phone') }}" class="w-full px-4 py-2.5 border rounded-lg focus:ring-2 focus:ring-indigo-500"></div>
                <div class="mb-4"><label class="block text-sm font-medium text-gray-700 mb-1">Address</label><input type="text" name="address1" value="{{ old('address1') }}" class="w-full px-4 py-2.5 border rounded-lg focus:ring-2 focus:ring-indigo-500"></div>
                <div class="grid grid-cols-2 gap-4 mb-4">
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">City</label><input type="text" name="city" value="{{ old('city') }}" class="w-full px-4 py-2.5 border rounded-lg focus:ring-2 focus:ring-indigo-500"></div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">Country *</label>
                        <select name="country" required class="w-full px-4 py-2.5 border rounded-lg focus:ring-2 focus:ring-indigo-500">
                            <option value="US">United States</option><option value="GB">United Kingdom</option><option value="DE">Germany</option><option value="RS">Serbia</option><option value="CA">Canada</option><option value="AU">Australia</option>
                        </select>
                    </div>
                </div>
                <div class="grid grid-cols-2 gap-4 mb-4">
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">Password *</label><input type="password" name="password" required class="w-full px-4 py-2.5 border rounded-lg focus:ring-2 focus:ring-indigo-500"></div>
                    <div><label class="block text-sm font-medium text-gray-700 mb-1">Confirm *</label><input type="password" name="password_confirmation" required class="w-full px-4 py-2.5 border rounded-lg focus:ring-2 focus:ring-indigo-500"></div>
                </div>
                <button type="submit" class="w-full bg-indigo-600 text-white py-2.5 rounded-lg font-medium hover:bg-indigo-700 transition mt-2">Create Account</button>
            </form>
        </div>
        <p class="text-center mt-6 text-sm text-gray-500">Already have an account? <a href="{{ route('login') }}" class="text-indigo-600 hover:underline font-medium">Sign in</a></p>
    </div>
</body>
</html>
