@extends('client.layouts.app')
@section('title', 'Dashboard')

@section('content')
<div class="mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Welcome back, {{ auth()->user()->first_name }}!</h1>
    <p class="text-gray-500">Here's an overview of your account.</p>
</div>

{{-- Stats --}}
<div class="grid grid-cols-2 md:grid-cols-5 gap-4 mb-8">
    <div class="bg-white rounded-xl shadow-sm border p-5 text-center">
        <p class="text-2xl font-bold text-indigo-600">{{ $stats['active_services'] }}</p>
        <p class="text-xs text-gray-500 mt-1">Active Services</p>
    </div>
    <div class="bg-white rounded-xl shadow-sm border p-5 text-center">
        <p class="text-2xl font-bold text-blue-600">{{ $stats['active_domains'] }}</p>
        <p class="text-xs text-gray-500 mt-1">Domains</p>
    </div>
    <div class="bg-white rounded-xl shadow-sm border p-5 text-center">
        <p class="text-2xl font-bold text-yellow-600">{{ $stats['unpaid_invoices'] }}</p>
        <p class="text-xs text-gray-500 mt-1">Unpaid Invoices</p>
    </div>
    <div class="bg-white rounded-xl shadow-sm border p-5 text-center">
        <p class="text-2xl font-bold text-green-600">{{ $stats['open_tickets'] }}</p>
        <p class="text-xs text-gray-500 mt-1">Open Tickets</p>
    </div>
    <div class="bg-white rounded-xl shadow-sm border p-5 text-center">
        <p class="text-2xl font-bold text-gray-900">${{ number_format($stats['credit_balance'], 2) }}</p>
        <p class="text-xs text-gray-500 mt-1">Credit Balance</p>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
    {{-- Active Services --}}
    <div class="bg-white rounded-xl shadow-sm border">
        <div class="p-5 border-b flex items-center justify-between">
            <h3 class="font-semibold text-gray-900">Your Services</h3>
            <a href="{{ route('client.services.index') }}" class="text-sm text-indigo-600 hover:underline">View All</a>
        </div>
        <div class="divide-y">
            @forelse($services as $service)
            <a href="{{ route('client.services.show', $service) }}" class="block p-4 hover:bg-gray-50">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-900">{{ $service->product->name ?? 'Unknown' }}</p>
                        <p class="text-xs text-gray-500">{{ $service->domain ?? 'No domain' }}</p>
                    </div>
                    <span class="px-2 py-0.5 text-xs rounded-full bg-green-100 text-green-800">Active</span>
                </div>
            </a>
            @empty
            <div class="p-4 text-sm text-gray-500 text-center">No active services. <a href="{{ route('client.order.index') }}" class="text-indigo-600 hover:underline">Order one now!</a></div>
            @endforelse
        </div>
    </div>

    {{-- Recent Invoices --}}
    <div class="bg-white rounded-xl shadow-sm border">
        <div class="p-5 border-b flex items-center justify-between">
            <h3 class="font-semibold text-gray-900">Recent Invoices</h3>
            <a href="{{ route('client.invoices.index') }}" class="text-sm text-indigo-600 hover:underline">View All</a>
        </div>
        <div class="divide-y">
            @forelse($recentInvoices as $invoice)
            <a href="{{ route('client.invoices.show', $invoice) }}" class="block p-4 hover:bg-gray-50">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium">{{ $invoice->invoice_number }}</p>
                        <p class="text-xs text-gray-500">Due: {{ $invoice->date_due?->format('M d, Y') }}</p>
                    </div>
                    <div class="text-right">
                        <p class="text-sm font-medium">${{ number_format($invoice->total, 2) }}</p>
                        <span class="px-2 py-0.5 text-xs rounded-full {{ $invoice->status === 'paid' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                            {{ ucfirst($invoice->status) }}
                        </span>
                    </div>
                </div>
            </a>
            @empty
            <p class="p-4 text-sm text-gray-500 text-center">No invoices.</p>
            @endforelse
        </div>
    </div>

    {{-- Recent Tickets --}}
    <div class="bg-white rounded-xl shadow-sm border">
        <div class="p-5 border-b flex items-center justify-between">
            <h3 class="font-semibold text-gray-900">Support Tickets</h3>
            <a href="{{ route('client.tickets.create') }}" class="text-sm bg-indigo-600 text-white px-3 py-1 rounded-md hover:bg-indigo-700">New Ticket</a>
        </div>
        <div class="divide-y">
            @forelse($recentTickets as $ticket)
            <a href="{{ route('client.tickets.show', $ticket) }}" class="block p-4 hover:bg-gray-50">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium">{{ Str::limit($ticket->subject, 45) }}</p>
                        <p class="text-xs text-gray-500">{{ $ticket->department->name ?? '' }} · {{ $ticket->created_at->diffForHumans() }}</p>
                    </div>
                    <span class="px-2 py-0.5 text-xs rounded-full
                        {{ $ticket->status === 'open' ? 'bg-green-100 text-green-800' : '' }}
                        {{ $ticket->status === 'answered' ? 'bg-blue-100 text-blue-800' : '' }}
                        {{ $ticket->status === 'customer_reply' ? 'bg-yellow-100 text-yellow-800' : '' }}
                        {{ $ticket->status === 'closed' ? 'bg-gray-100 text-gray-800' : '' }}
                    ">{{ ucfirst(str_replace('_', ' ', $ticket->status)) }}</span>
                </div>
            </a>
            @empty
            <p class="p-4 text-sm text-gray-500 text-center">No tickets.</p>
            @endforelse
        </div>
    </div>

    {{-- Domains --}}
    <div class="bg-white rounded-xl shadow-sm border">
        <div class="p-5 border-b flex items-center justify-between">
            <h3 class="font-semibold text-gray-900">Your Domains</h3>
            <a href="{{ route('client.domains.index') }}" class="text-sm text-indigo-600 hover:underline">View All</a>
        </div>
        <div class="divide-y">
            @forelse($domains as $domain)
            <a href="{{ route('client.domains.show', $domain) }}" class="block p-4 hover:bg-gray-50">
                <div class="flex items-center justify-between">
                    <p class="text-sm font-medium">{{ $domain->domain }}</p>
                    <p class="text-xs text-gray-500">Expires: {{ $domain->expiry_date?->format('M d, Y') }}</p>
                </div>
            </a>
            @empty
            <p class="p-4 text-sm text-gray-500 text-center">No domains registered.</p>
            @endforelse
        </div>
    </div>
</div>
@endsection
