<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Client Area') - {{ config('app.name') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>body { font-family: 'Inter', sans-serif; }</style>
</head>
<body class="bg-gray-50 min-h-screen">
    {{-- Navigation --}}
    <nav class="bg-white shadow-sm border-b">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center space-x-8">
                    <a href="{{ route('client.dashboard') }}" class="text-xl font-bold text-indigo-600">{{ config('app.name', 'HostBill') }}</a>
                    <div class="hidden md:flex space-x-1">
                        <a href="{{ route('client.dashboard') }}" class="px-3 py-2 rounded-md text-sm font-medium {{ request()->routeIs('client.dashboard') ? 'bg-indigo-50 text-indigo-700' : 'text-gray-600 hover:bg-gray-50' }}">Dashboard</a>
                        <a href="{{ route('client.services.index') }}" class="px-3 py-2 rounded-md text-sm font-medium {{ request()->routeIs('client.services.*') ? 'bg-indigo-50 text-indigo-700' : 'text-gray-600 hover:bg-gray-50' }}">Services</a>
                        <a href="{{ route('client.domains.index') }}" class="px-3 py-2 rounded-md text-sm font-medium {{ request()->routeIs('client.domains.*') ? 'bg-indigo-50 text-indigo-700' : 'text-gray-600 hover:bg-gray-50' }}">Domains</a>
                        <a href="{{ route('client.invoices.index') }}" class="px-3 py-2 rounded-md text-sm font-medium {{ request()->routeIs('client.invoices.*') ? 'bg-indigo-50 text-indigo-700' : 'text-gray-600 hover:bg-gray-50' }}">Billing</a>
                        <a href="{{ route('client.tickets.index') }}" class="px-3 py-2 rounded-md text-sm font-medium {{ request()->routeIs('client.tickets.*') ? 'bg-indigo-50 text-indigo-700' : 'text-gray-600 hover:bg-gray-50' }}">Support</a>
                        <a href="{{ route('client.order.index') }}" class="px-3 py-2 rounded-md text-sm font-medium bg-indigo-600 text-white hover:bg-indigo-700">Order New</a>
                    </div>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="{{ route('client.profile.edit') }}" class="text-sm text-gray-600 hover:text-gray-900">{{ auth()->user()->full_name }}</a>
                    <form method="POST" action="{{ route('logout') }}">@csrf
                        <button class="text-sm text-gray-400 hover:text-red-500">Logout</button>
                    </form>
                </div>
            </div>
        </div>
    </nav>

    {{-- Alerts --}}
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pt-4">
        @if(session('success'))<div class="mb-4 p-4 bg-green-50 border border-green-200 text-green-700 rounded-lg">{{ session('success') }}</div>@endif
        @if(session('error'))<div class="mb-4 p-4 bg-red-50 border border-red-200 text-red-700 rounded-lg">{{ session('error') }}</div>@endif
        @if($errors->any())<div class="mb-4 p-4 bg-red-50 border border-red-200 text-red-700 rounded-lg">@foreach($errors->all() as $e)<p>{{ $e }}</p>@endforeach</div>@endif
    </div>

    {{-- Content --}}
    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
        @yield('content')
    </main>

    {{-- Footer --}}
    <footer class="border-t mt-12 py-6">
        <div class="max-w-7xl mx-auto px-4 text-center text-sm text-gray-500">
            &copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.
        </div>
    </footer>
</body>
</html>
