<?php

use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Admin\DashboardController as AdminDashboard;
use App\Http\Controllers\Admin\ClientController as AdminClientController;
use App\Http\Controllers\Admin\ProductController as AdminProductController;
use App\Http\Controllers\Admin\ServerController as AdminServerController;
use App\Http\Controllers\Admin\OrderController as AdminOrderController;
use App\Http\Controllers\Admin\InvoiceController as AdminInvoiceController;
use App\Http\Controllers\Admin\ServiceController as AdminServiceController;
use App\Http\Controllers\Admin\TicketController as AdminTicketController;
use App\Http\Controllers\Admin\SettingController as AdminSettingController;
use App\Http\Controllers\Client\DashboardController as ClientDashboard;
use App\Http\Controllers\Client\ServiceController as ClientServiceController;
use App\Http\Controllers\Client\InvoiceController as ClientInvoiceController;
use App\Http\Controllers\Client\TicketController as ClientTicketController;
use App\Http\Controllers\Client\DomainController as ClientDomainController;
use App\Http\Controllers\Client\OrderController as ClientOrderController;
use App\Http\Controllers\Client\ProfileController as ClientProfileController;
use Illuminate\Support\Facades\Route;

Route::get('/', fn() => redirect()->route('login'));

// Auth
Route::middleware('guest')->group(function () {
    Route::get('login', [LoginController::class, 'showLoginForm'])->name('login');
    Route::post('login', [LoginController::class, 'login']);
    Route::get('register', [RegisterController::class, 'showRegistrationForm'])->name('register');
    Route::post('register', [RegisterController::class, 'register']);
});
Route::post('logout', [LoginController::class, 'logout'])->name('logout')->middleware('auth');

// Admin Panel
Route::prefix('admin')->name('admin.')->middleware(['auth', 'admin'])->group(function () {
    Route::get('/', [AdminDashboard::class, 'index'])->name('dashboard');
    Route::resource('clients', AdminClientController::class);
    Route::post('clients/{client}/toggle-status', [AdminClientController::class, 'toggleStatus'])->name('clients.toggle-status');
    Route::post('clients/{client}/add-credit', [AdminClientController::class, 'addCredit'])->name('clients.add-credit');
    Route::resource('products', AdminProductController::class);
    Route::resource('servers', AdminServerController::class);
    Route::post('servers/{server}/test-connection', [AdminServerController::class, 'testConnection'])->name('servers.test-connection');
    Route::resource('orders', AdminOrderController::class)->only(['index', 'show']);
    Route::post('orders/{order}/accept', [AdminOrderController::class, 'accept'])->name('orders.accept');
    Route::post('orders/{order}/cancel', [AdminOrderController::class, 'cancel'])->name('orders.cancel');
    Route::resource('services', AdminServiceController::class);
    Route::post('services/{service}/suspend', [AdminServiceController::class, 'suspend'])->name('services.suspend');
    Route::post('services/{service}/unsuspend', [AdminServiceController::class, 'unsuspend'])->name('services.unsuspend');
    Route::post('services/{service}/terminate', [AdminServiceController::class, 'terminate'])->name('services.terminate');
    Route::resource('invoices', AdminInvoiceController::class);
    Route::post('invoices/{invoice}/mark-paid', [AdminInvoiceController::class, 'markPaid'])->name('invoices.mark-paid');
    Route::post('invoices/{invoice}/cancel', [AdminInvoiceController::class, 'cancelInvoice'])->name('invoices.cancel');
    Route::get('invoices/{invoice}/pdf', [AdminInvoiceController::class, 'downloadPdf'])->name('invoices.pdf');
    Route::resource('tickets', AdminTicketController::class);
    Route::post('tickets/{ticket}/reply', [AdminTicketController::class, 'reply'])->name('tickets.reply');
    Route::post('tickets/{ticket}/close', [AdminTicketController::class, 'close'])->name('tickets.close');
    Route::get('settings', [AdminSettingController::class, 'index'])->name('settings.index');
    Route::post('settings', [AdminSettingController::class, 'update'])->name('settings.update');
});

// Client Portal
Route::prefix('client')->name('client.')->middleware(['auth', 'client'])->group(function () {
    Route::get('/', [ClientDashboard::class, 'index'])->name('dashboard');
    Route::get('services', [ClientServiceController::class, 'index'])->name('services.index');
    Route::get('services/{service}', [ClientServiceController::class, 'show'])->name('services.show');
    Route::get('invoices', [ClientInvoiceController::class, 'index'])->name('invoices.index');
    Route::get('invoices/{invoice}', [ClientInvoiceController::class, 'show'])->name('invoices.show');
    Route::post('invoices/{invoice}/pay', [ClientInvoiceController::class, 'pay'])->name('invoices.pay');
    Route::resource('tickets', ClientTicketController::class)->only(['index', 'show', 'create', 'store']);
    Route::post('tickets/{ticket}/reply', [ClientTicketController::class, 'reply'])->name('tickets.reply');
    Route::post('tickets/{ticket}/close', [ClientTicketController::class, 'close'])->name('tickets.close');
    Route::get('domains', [ClientDomainController::class, 'index'])->name('domains.index');
    Route::get('domains/{domain}', [ClientDomainController::class, 'show'])->name('domains.show');
    Route::get('order', [ClientOrderController::class, 'index'])->name('order.index');
    Route::get('order/{product}', [ClientOrderController::class, 'configure'])->name('order.configure');
    Route::post('order', [ClientOrderController::class, 'store'])->name('order.store');
    Route::get('profile', [ClientProfileController::class, 'edit'])->name('profile.edit');
    Route::put('profile', [ClientProfileController::class, 'update'])->name('profile.update');
});

// Webhooks
Route::post('webhooks/stripe', [\App\Http\Controllers\Webhook\StripeWebhookController::class, 'handle']);
Route::post('webhooks/paypal', [\App\Http\Controllers\Webhook\PayPalWebhookController::class, 'handle']);
